/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.datatransfer.Transferable;
import java.awt.dnd.InvalidDnDOperationException;
import java.util.Map;
import sun.awt.X11.MotifDnDConstants;
import sun.awt.X11.WindowPropertyGetter;
import sun.awt.X11.XClientMessageEvent;
import sun.awt.X11.XDragSourceProtocol;
import sun.awt.X11.XDragSourceProtocolListener;
import sun.awt.X11.XErrorHandler;
import sun.awt.X11.XEvent;
import sun.awt.X11.XEventDispatcher;
import sun.awt.X11.XException;
import sun.awt.X11.XSelectionRequestEvent;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWindow;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

class MotifDnDDragSourceProtocol
extends XDragSourceProtocol
implements XEventDispatcher {
    private static final Unsafe unsafe = XlibWrapper.unsafe;
    private long targetEnterServerTime = 0L;

    protected MotifDnDDragSourceProtocol(XDragSourceProtocolListener listener) {
        super(listener);
        XToolkit.addEventDispatcher(XWindow.getXAWTRootWindow().getWindow(), this);
    }

    static XDragSourceProtocol createInstance(XDragSourceProtocolListener listener) {
        return new MotifDnDDragSourceProtocol(listener);
    }

    @Override
    public String getProtocolName() {
        return "MotifDnD";
    }

    @Override
    protected void initializeDragImpl(int actions, Transferable contents, Map formatMap, long[] formats) throws InvalidDnDOperationException, IllegalArgumentException, XException {
        long window = XDragSourceProtocol.getDragSourceWindow();
        try {
            int index = MotifDnDConstants.getIndexForTargetList(formats);
            MotifDnDConstants.writeDragInitiatorInfoStruct(window, index);
        }
        catch (XException xe) {
            this.cleanup();
            throw xe;
        }
        catch (InvalidDnDOperationException idoe) {
            this.cleanup();
            throw idoe;
        }
        if (!MotifDnDConstants.MotifDnDSelection.setOwner(contents, formatMap, formats, 0L)) {
            this.cleanup();
            throw new InvalidDnDOperationException("Cannot acquire selection ownership");
        }
    }

    @Override
    public boolean processClientMessage(XClientMessageEvent xclient) {
        if (xclient.get_message_type() != MotifDnDConstants.XA_MOTIF_DRAG_AND_DROP_MESSAGE.getAtom()) {
            return false;
        }
        long data = xclient.get_data();
        byte reason = (byte)(unsafe.getByte(data) & 0x7F);
        byte origin = (byte)(unsafe.getByte(data) & 0xFFFFFF80);
        byte byteOrder = unsafe.getByte(data + 1L);
        boolean swapNeeded = byteOrder != MotifDnDConstants.getByteOrderByte();
        int action = 0;
        int x = 0;
        int y = 0;
        if (origin != -128) {
            return false;
        }
        switch (reason) {
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                break;
            }
            default: {
                return false;
            }
        }
        int t = unsafe.getInt(data + 4L);
        if (swapNeeded) {
            t = MotifDnDConstants.Swapper.swap(t);
        }
        long time = (long)t & 0xFFFFFFFFL;
        if (this.targetEnterServerTime == 0L || time < this.targetEnterServerTime) {
            return true;
        }
        if (reason != 4) {
            short flags = unsafe.getShort(data + 2L);
            if (swapNeeded) {
                flags = MotifDnDConstants.Swapper.swap(flags);
            }
            byte status = (byte)((flags & 0xF0) >> 4);
            byte motif_action = (byte)((flags & 0xF) >> 0);
            action = status == 3 ? MotifDnDConstants.getJavaActionsForMotifActions(motif_action) : 0;
            short tx = unsafe.getShort(data + 8L);
            short ty = unsafe.getShort(data + 10L);
            if (swapNeeded) {
                tx = MotifDnDConstants.Swapper.swap(tx);
                ty = MotifDnDConstants.Swapper.swap(ty);
            }
            x = tx;
            y = ty;
        }
        this.getProtocolListener().handleDragReply(action, x, y);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XDragSourceProtocol.TargetWindowInfo getTargetWindowInfo(long window) {
        assert (XToolkit.isAWTLockHeldByCurrentThread());
        WindowPropertyGetter wpg = new WindowPropertyGetter(window, MotifDnDConstants.XA_MOTIF_DRAG_RECEIVER_INFO, 0L, 65535L, false, 0L);
        try {
            int status = wpg.execute(XErrorHandler.IgnoreBadWindowHandler.getInstance());
            if (status == 0 && wpg.getData() != 0L && wpg.getActualType() != 0L && wpg.getActualFormat() == 8 && wpg.getNumberOfItems() >= 16) {
                long data = wpg.getData();
                byte byteOrderByte = unsafe.getByte(data);
                byte dragProtocolStyle = unsafe.getByte(data + 2L);
                switch (dragProtocolStyle) {
                    case 2: 
                    case 4: 
                    case 5: 
                    case 6: {
                        int proxy = unsafe.getInt(data + 4L);
                        if (byteOrderByte != MotifDnDConstants.getByteOrderByte()) {
                            proxy = MotifDnDConstants.Swapper.swap(proxy);
                        }
                        byte protocolVersion = unsafe.getByte(data + 1L);
                        XDragSourceProtocol.TargetWindowInfo targetWindowInfo = new XDragSourceProtocol.TargetWindowInfo(proxy, protocolVersion);
                        return targetWindowInfo;
                    }
                }
                XDragSourceProtocol.TargetWindowInfo targetWindowInfo = null;
                return targetWindowInfo;
            }
            XDragSourceProtocol.TargetWindowInfo targetWindowInfo = null;
            return targetWindowInfo;
        }
        finally {
            wpg.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendEnterMessage(long[] formats, int sourceAction, int sourceActions, long time) {
        assert (XToolkit.isAWTLockHeldByCurrentThread());
        assert (this.getTargetWindow() != 0L);
        assert (formats != null);
        this.targetEnterServerTime = time;
        XClientMessageEvent msg = new XClientMessageEvent();
        try {
            msg.set_type(33);
            msg.set_window(this.getTargetWindow());
            msg.set_format(8);
            msg.set_message_type(MotifDnDConstants.XA_MOTIF_DRAG_AND_DROP_MESSAGE.getAtom());
            long data = msg.get_data();
            int flags = MotifDnDConstants.getMotifActionsForJavaActions(sourceAction) << 0 | MotifDnDConstants.getMotifActionsForJavaActions(sourceActions) << 8;
            unsafe.putByte(data, (byte)0);
            unsafe.putByte(data + 1L, MotifDnDConstants.getByteOrderByte());
            unsafe.putShort(data + 2L, (short)flags);
            unsafe.putInt(data + 4L, (int)time);
            unsafe.putInt(data + 8L, (int)XDragSourceProtocol.getDragSourceWindow());
            unsafe.putInt(data + 12L, (int)MotifDnDConstants.XA_MOTIF_ATOM_0.getAtom());
            XlibWrapper.XSendEvent(XToolkit.getDisplay(), this.getTargetProxyWindow(), false, 0L, msg.pData);
        }
        finally {
            msg.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendMoveMessage(int xRoot, int yRoot, int sourceAction, int sourceActions, long time) {
        assert (XToolkit.isAWTLockHeldByCurrentThread());
        assert (this.getTargetWindow() != 0L);
        XClientMessageEvent msg = new XClientMessageEvent();
        try {
            msg.set_type(33);
            msg.set_window(this.getTargetWindow());
            msg.set_format(8);
            msg.set_message_type(MotifDnDConstants.XA_MOTIF_DRAG_AND_DROP_MESSAGE.getAtom());
            long data = msg.get_data();
            int flags = MotifDnDConstants.getMotifActionsForJavaActions(sourceAction) << 0 | MotifDnDConstants.getMotifActionsForJavaActions(sourceActions) << 8;
            unsafe.putByte(data, (byte)2);
            unsafe.putByte(data + 1L, MotifDnDConstants.getByteOrderByte());
            unsafe.putShort(data + 2L, (short)flags);
            unsafe.putInt(data + 4L, (int)time);
            unsafe.putShort(data + 8L, (short)xRoot);
            unsafe.putShort(data + 10L, (short)yRoot);
            XlibWrapper.XSendEvent(XToolkit.getDisplay(), this.getTargetProxyWindow(), false, 0L, msg.pData);
        }
        finally {
            msg.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendLeaveMessage(long time) {
        assert (XToolkit.isAWTLockHeldByCurrentThread());
        assert (this.getTargetWindow() != 0L);
        XClientMessageEvent msg = new XClientMessageEvent();
        try {
            msg.set_type(33);
            msg.set_window(this.getTargetWindow());
            msg.set_format(8);
            msg.set_message_type(MotifDnDConstants.XA_MOTIF_DRAG_AND_DROP_MESSAGE.getAtom());
            long data = msg.get_data();
            unsafe.putByte(data, (byte)1);
            unsafe.putByte(data + 1L, MotifDnDConstants.getByteOrderByte());
            unsafe.putShort(data + 2L, (short)0);
            unsafe.putInt(data + 4L, (int)time);
            unsafe.putInt(data + 8L, (int)XDragSourceProtocol.getDragSourceWindow());
            XlibWrapper.XSendEvent(XToolkit.getDisplay(), this.getTargetProxyWindow(), false, 0L, msg.pData);
        }
        finally {
            msg.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void sendDropMessage(int xRoot, int yRoot, int sourceAction, int sourceActions, long time) {
        assert (XToolkit.isAWTLockHeldByCurrentThread());
        assert (this.getTargetWindow() != 0L);
        this.sendLeaveMessage(time);
        XClientMessageEvent msg = new XClientMessageEvent();
        try {
            msg.set_type(33);
            msg.set_window(this.getTargetWindow());
            msg.set_format(8);
            msg.set_message_type(MotifDnDConstants.XA_MOTIF_DRAG_AND_DROP_MESSAGE.getAtom());
            long data = msg.get_data();
            int flags = MotifDnDConstants.getMotifActionsForJavaActions(sourceAction) << 0 | MotifDnDConstants.getMotifActionsForJavaActions(sourceActions) << 8;
            unsafe.putByte(data, (byte)5);
            unsafe.putByte(data + 1L, MotifDnDConstants.getByteOrderByte());
            unsafe.putShort(data + 2L, (short)flags);
            unsafe.putInt(data + 4L, (int)time);
            unsafe.putShort(data + 8L, (short)xRoot);
            unsafe.putShort(data + 10L, (short)yRoot);
            unsafe.putInt(data + 12L, (int)MotifDnDConstants.XA_MOTIF_ATOM_0.getAtom());
            unsafe.putInt(data + 16L, (int)XDragSourceProtocol.getDragSourceWindow());
            XlibWrapper.XSendEvent(XToolkit.getDisplay(), this.getTargetProxyWindow(), false, 0L, msg.pData);
        }
        finally {
            msg.dispose();
        }
    }

    @Override
    public boolean processProxyModeEvent(XClientMessageEvent xclient, long sourceWindow) {
        return false;
    }

    @Override
    public void cleanupTargetInfo() {
        super.cleanupTargetInfo();
        this.targetEnterServerTime = 0L;
    }

    @Override
    public void dispatchEvent(XEvent ev) {
        switch (ev.get_type()) {
            case 30: {
                XSelectionRequestEvent xsre = ev.get_xselectionrequest();
                long atom = xsre.get_selection();
                if (atom != MotifDnDConstants.XA_MOTIF_ATOM_0.getAtom()) break;
                long target = xsre.get_target();
                if (target == MotifDnDConstants.XA_XmTRANSFER_SUCCESS.getAtom()) {
                    this.getProtocolListener().handleDragFinished(true);
                    break;
                }
                if (target != MotifDnDConstants.XA_XmTRANSFER_FAILURE.getAtom()) break;
                this.getProtocolListener().handleDragFinished(false);
            }
        }
    }
}

