/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.http;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import sun.net.www.http.ClientVector;
import sun.net.www.http.HttpClient;
import sun.net.www.http.KeepAliveEntry;
import sun.net.www.http.KeepAliveKey;
import sun.net.www.protocol.http.HttpURLConnection;
import sun.security.action.GetIntegerAction;
import sun.util.logging.PlatformLogger;

public class KeepAliveCache
extends HashMap<KeepAliveKey, ClientVector>
implements Runnable {
    private static final long serialVersionUID = -2937172892064557949L;
    private static final String keepAliveProp = "http.keepAlive.time.";
    private static final int userKeepAliveServer;
    private static final int userKeepAliveProxy;
    static final PlatformLogger logger;
    static final int MAX_CONNECTIONS = 5;
    static int result;
    static final int LIFETIME = 5000;
    private Thread keepAliveTimer = null;

    static int getUserKeepAliveSeconds(String type) {
        int v = AccessController.doPrivileged(new GetIntegerAction(keepAliveProp + type, -1));
        return v < -1 ? -1 : v;
    }

    static int getMaxConnections() {
        if (result == -1 && (result = AccessController.doPrivileged(new GetIntegerAction("http.maxConnections", 5)).intValue()) <= 0) {
            result = 5;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(URL url, Object obj, HttpClient http) {
        HttpClient oldClient = null;
        KeepAliveCache keepAliveCache = this;
        synchronized (keepAliveCache) {
            KeepAliveKey key;
            ClientVector v;
            boolean startThread;
            boolean bl = startThread = this.keepAliveTimer == null;
            if (!startThread && !this.keepAliveTimer.isAlive()) {
                startThread = true;
            }
            if (startThread) {
                this.clear();
                final KeepAliveCache cache = this;
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        ThreadGroup grp = Thread.currentThread().getThreadGroup();
                        ThreadGroup parent = null;
                        while ((parent = grp.getParent()) != null) {
                            grp = parent;
                        }
                        KeepAliveCache.this.keepAliveTimer = new Thread(grp, cache, "Keep-Alive-Timer");
                        KeepAliveCache.this.keepAliveTimer.setDaemon(true);
                        KeepAliveCache.this.keepAliveTimer.setPriority(8);
                        KeepAliveCache.this.keepAliveTimer.setContextClassLoader(null);
                        KeepAliveCache.this.keepAliveTimer.start();
                        return null;
                    }
                });
            }
            if ((v = (ClientVector)super.get(key = new KeepAliveKey(url, obj))) == null) {
                int keepAliveTimeout = http.getKeepAliveTimeout();
                if (keepAliveTimeout == 0) {
                    keepAliveTimeout = KeepAliveCache.getUserKeepAlive(http.getUsingProxy());
                    if (keepAliveTimeout == -1) {
                        keepAliveTimeout = 5;
                    }
                } else if (keepAliveTimeout == -1) {
                    keepAliveTimeout = KeepAliveCache.getUserKeepAlive(http.getUsingProxy());
                    if (keepAliveTimeout == -1) {
                        keepAliveTimeout = http.getUsingProxy() ? 60 : 5;
                    }
                } else if (keepAliveTimeout == -2) {
                    keepAliveTimeout = 0;
                }
                assert (keepAliveTimeout >= 0);
                if (keepAliveTimeout == 0) {
                    oldClient = http;
                } else {
                    v = new ClientVector(keepAliveTimeout * 1000);
                    v.put(http);
                    super.put(key, v);
                }
            } else {
                oldClient = v.put(http);
            }
        }
        if (oldClient != null) {
            oldClient.closeServer();
        }
    }

    private static int getUserKeepAlive(boolean isProxy) {
        return isProxy ? userKeepAliveProxy : userKeepAliveServer;
    }

    public synchronized void remove(HttpClient h, Object obj) {
        KeepAliveKey key = new KeepAliveKey(h.url, obj);
        ClientVector v = (ClientVector)super.get(key);
        if (v != null) {
            v.remove(h);
            if (v.isEmpty()) {
                this.removeVector(key);
            }
        }
    }

    synchronized void removeVector(KeepAliveKey k) {
        super.remove(k);
    }

    public synchronized HttpClient get(URL url, Object obj) {
        KeepAliveKey key = new KeepAliveKey(url, obj);
        ClientVector v = (ClientVector)super.get(key);
        if (v == null) {
            return null;
        }
        return v.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        do {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ArrayList<HttpClient> closeList = null;
            KeepAliveCache keepAliveCache = this;
            synchronized (keepAliveCache) {
                long currentTime = System.currentTimeMillis();
                ArrayList<KeepAliveKey> keysToRemove = new ArrayList<KeepAliveKey>();
                for (KeepAliveKey key : this.keySet()) {
                    ClientVector v;
                    ClientVector clientVector = v = (ClientVector)this.get(key);
                    synchronized (clientVector) {
                        KeepAliveEntry e = (KeepAliveEntry)v.peekLast();
                        while (e != null && currentTime - e.idleStartTime > (long)v.nap) {
                            v.pollLast();
                            if (closeList == null) {
                                closeList = new ArrayList<HttpClient>();
                            }
                            closeList.add(e.hc);
                            e = (KeepAliveEntry)v.peekLast();
                        }
                        if (v.isEmpty()) {
                            keysToRemove.add(key);
                        }
                    }
                }
                for (KeepAliveKey key : keysToRemove) {
                    this.removeVector(key);
                }
            }
            if (closeList == null) continue;
            for (HttpClient hc : closeList) {
                hc.closeServer();
            }
        } while (!this.isEmpty());
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        throw new NotSerializableException();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        throw new NotSerializableException();
    }

    static {
        logger = HttpURLConnection.getHttpLogger();
        userKeepAliveServer = KeepAliveCache.getUserKeepAliveSeconds("server");
        userKeepAliveProxy = KeepAliveCache.getUserKeepAliveSeconds("proxy");
        result = -1;
    }
}

