/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.http;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayDeque;
import sun.net.www.http.HttpClient;
import sun.net.www.http.KeepAliveCache;
import sun.net.www.http.KeepAliveEntry;
import sun.util.logging.PlatformLogger;

class ClientVector
extends ArrayDeque<KeepAliveEntry> {
    private static final long serialVersionUID = -8680532108106489459L;
    int nap;

    ClientVector(int nap) {
        this.nap = nap;
    }

    synchronized HttpClient get() {
        KeepAliveEntry e = (KeepAliveEntry)this.peekFirst();
        if (e == null) {
            return null;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - e.idleStartTime > (long)this.nap) {
            return null;
        }
        this.pollFirst();
        if (KeepAliveCache.logger.isLoggable(PlatformLogger.Level.FINEST)) {
            String msg = "cached HttpClient was idle for " + Long.toString(currentTime - e.idleStartTime);
            KeepAliveCache.logger.finest(msg);
        }
        return e.hc;
    }

    synchronized HttpClient put(HttpClient h) {
        HttpClient staleClient = null;
        assert (KeepAliveCache.getMaxConnections() > 0);
        if (this.size() >= KeepAliveCache.getMaxConnections()) {
            staleClient = ((KeepAliveEntry)this.removeLast()).hc;
        }
        this.addFirst(new KeepAliveEntry(h, System.currentTimeMillis()));
        return staleClient;
    }

    synchronized boolean remove(HttpClient h) {
        for (KeepAliveEntry curr : this) {
            if (curr.hc != h) continue;
            return super.remove(curr);
        }
        return false;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        throw new NotSerializableException();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        throw new NotSerializableException();
    }
}

