/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.auth;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.security.Principal;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import jdk.Exported;

@Exported
public final class LdapPrincipal
implements Principal,
Serializable {
    private static final long serialVersionUID = 6820120005580754861L;
    private final String nameString;
    private final LdapName name;

    public LdapPrincipal(String name) throws InvalidNameException {
        if (name == null) {
            throw new NullPointerException("null name is illegal");
        }
        this.name = this.getLdapName(name);
        this.nameString = name;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof LdapPrincipal) {
            try {
                return this.name.equals(this.getLdapName(((LdapPrincipal)object).getName()));
            }
            catch (InvalidNameException e) {
                return false;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public String getName() {
        return this.nameString;
    }

    @Override
    public String toString() {
        return this.name.toString();
    }

    private LdapName getLdapName(String name) throws InvalidNameException {
        return new LdapName(name);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this.name == null || this.nameString == null) {
            throw new InvalidObjectException("null name/nameString is illegal");
        }
        try {
            if (!this.name.equals(this.getLdapName(this.nameString))) {
                throw new InvalidObjectException("Inconsistent names");
            }
        }
        catch (InvalidNameException e) {
            InvalidObjectException nse = new InvalidObjectException("Invalid Name");
            nse.initCause(e);
            throw nse;
        }
    }
}

