/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.metadata;

import java.util.ArrayList;
import java.util.List;
import javax.imageio.metadata.IIOAttr;
import javax.imageio.metadata.IIODOMException;
import javax.imageio.metadata.IIONamedNodeMap;
import javax.imageio.metadata.IIONodeList;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;
import org.w3c.dom.UserDataHandler;

public class IIOMetadataNode
implements Element,
NodeList {
    private String nodeName = null;
    private String nodeValue = null;
    private Object userObject = null;
    private IIOMetadataNode parent = null;
    private int numChildren = 0;
    private IIOMetadataNode firstChild = null;
    private IIOMetadataNode lastChild = null;
    private IIOMetadataNode nextSibling = null;
    private IIOMetadataNode previousSibling = null;
    private List attributes = new ArrayList();

    public IIOMetadataNode() {
    }

    public IIOMetadataNode(String nodeName) {
        this.nodeName = nodeName;
    }

    private void checkNode(Node node) throws DOMException {
        if (node == null) {
            return;
        }
        if (!(node instanceof IIOMetadataNode)) {
            throw new IIODOMException(4, "Node not an IIOMetadataNode!");
        }
    }

    @Override
    public String getNodeName() {
        return this.nodeName;
    }

    @Override
    public String getNodeValue() {
        return this.nodeValue;
    }

    @Override
    public void setNodeValue(String nodeValue) {
        this.nodeValue = nodeValue;
    }

    @Override
    public short getNodeType() {
        return 1;
    }

    @Override
    public Node getParentNode() {
        return this.parent;
    }

    @Override
    public NodeList getChildNodes() {
        return this;
    }

    @Override
    public Node getFirstChild() {
        return this.firstChild;
    }

    @Override
    public Node getLastChild() {
        return this.lastChild;
    }

    @Override
    public Node getPreviousSibling() {
        return this.previousSibling;
    }

    @Override
    public Node getNextSibling() {
        return this.nextSibling;
    }

    @Override
    public NamedNodeMap getAttributes() {
        return new IIONamedNodeMap(this.attributes);
    }

    @Override
    public Document getOwnerDocument() {
        return null;
    }

    @Override
    public Node insertBefore(Node newChild, Node refChild) {
        if (newChild == null) {
            throw new IllegalArgumentException("newChild == null!");
        }
        this.checkNode(newChild);
        this.checkNode(refChild);
        IIOMetadataNode newChildNode = (IIOMetadataNode)newChild;
        IIOMetadataNode refChildNode = (IIOMetadataNode)refChild;
        IIOMetadataNode previous = null;
        IIOMetadataNode next = null;
        if (refChild == null) {
            previous = this.lastChild;
            next = null;
            this.lastChild = newChildNode;
        } else {
            previous = refChildNode.previousSibling;
            next = refChildNode;
        }
        if (previous != null) {
            previous.nextSibling = newChildNode;
        }
        if (next != null) {
            next.previousSibling = newChildNode;
        }
        newChildNode.parent = this;
        newChildNode.previousSibling = previous;
        newChildNode.nextSibling = next;
        if (this.firstChild == refChildNode) {
            this.firstChild = newChildNode;
        }
        ++this.numChildren;
        return newChildNode;
    }

    @Override
    public Node replaceChild(Node newChild, Node oldChild) {
        if (newChild == null) {
            throw new IllegalArgumentException("newChild == null!");
        }
        this.checkNode(newChild);
        this.checkNode(oldChild);
        IIOMetadataNode newChildNode = (IIOMetadataNode)newChild;
        IIOMetadataNode oldChildNode = (IIOMetadataNode)oldChild;
        IIOMetadataNode previous = oldChildNode.previousSibling;
        IIOMetadataNode next = oldChildNode.nextSibling;
        if (previous != null) {
            previous.nextSibling = newChildNode;
        }
        if (next != null) {
            next.previousSibling = newChildNode;
        }
        newChildNode.parent = this;
        newChildNode.previousSibling = previous;
        newChildNode.nextSibling = next;
        if (this.firstChild == oldChildNode) {
            this.firstChild = newChildNode;
        }
        if (this.lastChild == oldChildNode) {
            this.lastChild = newChildNode;
        }
        oldChildNode.parent = null;
        oldChildNode.previousSibling = null;
        oldChildNode.nextSibling = null;
        return oldChildNode;
    }

    @Override
    public Node removeChild(Node oldChild) {
        if (oldChild == null) {
            throw new IllegalArgumentException("oldChild == null!");
        }
        this.checkNode(oldChild);
        IIOMetadataNode oldChildNode = (IIOMetadataNode)oldChild;
        IIOMetadataNode previous = oldChildNode.previousSibling;
        IIOMetadataNode next = oldChildNode.nextSibling;
        if (previous != null) {
            previous.nextSibling = next;
        }
        if (next != null) {
            next.previousSibling = previous;
        }
        if (this.firstChild == oldChildNode) {
            this.firstChild = next;
        }
        if (this.lastChild == oldChildNode) {
            this.lastChild = previous;
        }
        oldChildNode.parent = null;
        oldChildNode.previousSibling = null;
        oldChildNode.nextSibling = null;
        --this.numChildren;
        return oldChildNode;
    }

    @Override
    public Node appendChild(Node newChild) {
        if (newChild == null) {
            throw new IllegalArgumentException("newChild == null!");
        }
        this.checkNode(newChild);
        return this.insertBefore(newChild, null);
    }

    @Override
    public boolean hasChildNodes() {
        return this.numChildren > 0;
    }

    @Override
    public Node cloneNode(boolean deep) {
        IIOMetadataNode newNode = new IIOMetadataNode(this.nodeName);
        newNode.setUserObject(this.getUserObject());
        if (deep) {
            IIOMetadataNode child = this.firstChild;
            while (child != null) {
                newNode.appendChild(child.cloneNode(true));
                child = child.nextSibling;
            }
        }
        return newNode;
    }

    @Override
    public void normalize() {
    }

    @Override
    public boolean isSupported(String feature, String version) {
        return false;
    }

    @Override
    public String getNamespaceURI() throws DOMException {
        return null;
    }

    @Override
    public String getPrefix() {
        return null;
    }

    @Override
    public void setPrefix(String prefix) {
    }

    @Override
    public String getLocalName() {
        return this.nodeName;
    }

    @Override
    public String getTagName() {
        return this.nodeName;
    }

    @Override
    public String getAttribute(String name) {
        Attr attr = this.getAttributeNode(name);
        if (attr == null) {
            return "";
        }
        return attr.getValue();
    }

    @Override
    public String getAttributeNS(String namespaceURI, String localName) {
        return this.getAttribute(localName);
    }

    @Override
    public void setAttribute(String name, String value) {
        boolean valid = true;
        char[] chs = name.toCharArray();
        for (int i = 0; i < chs.length; ++i) {
            if (chs[i] < '\ufffe') continue;
            valid = false;
            break;
        }
        if (!valid) {
            throw new IIODOMException(5, "Attribute name is illegal!");
        }
        this.removeAttribute(name, false);
        this.attributes.add(new IIOAttr(this, name, value));
    }

    @Override
    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) {
        this.setAttribute(qualifiedName, value);
    }

    @Override
    public void removeAttribute(String name) {
        this.removeAttribute(name, true);
    }

    private void removeAttribute(String name, boolean checkPresent) {
        int numAttributes = this.attributes.size();
        for (int i = 0; i < numAttributes; ++i) {
            IIOAttr attr = (IIOAttr)this.attributes.get(i);
            if (!name.equals(attr.getName())) continue;
            attr.setOwnerElement(null);
            this.attributes.remove(i);
            return;
        }
        if (checkPresent) {
            throw new IIODOMException(8, "No such attribute!");
        }
    }

    @Override
    public void removeAttributeNS(String namespaceURI, String localName) {
        this.removeAttribute(localName);
    }

    @Override
    public Attr getAttributeNode(String name) {
        Node node = this.getAttributes().getNamedItem(name);
        return (Attr)node;
    }

    @Override
    public Attr getAttributeNodeNS(String namespaceURI, String localName) {
        return this.getAttributeNode(localName);
    }

    @Override
    public Attr setAttributeNode(Attr newAttr) throws DOMException {
        IIOAttr attr;
        Element owner = newAttr.getOwnerElement();
        if (owner != null) {
            if (owner == this) {
                return null;
            }
            throw new DOMException(10, "Attribute is already in use");
        }
        if (newAttr instanceof IIOAttr) {
            attr = (IIOAttr)newAttr;
            attr.setOwnerElement(this);
        } else {
            attr = new IIOAttr(this, newAttr.getName(), newAttr.getValue());
        }
        Attr oldAttr = this.getAttributeNode(attr.getName());
        if (oldAttr != null) {
            this.removeAttributeNode(oldAttr);
        }
        this.attributes.add(attr);
        return oldAttr;
    }

    @Override
    public Attr setAttributeNodeNS(Attr newAttr) {
        return this.setAttributeNode(newAttr);
    }

    @Override
    public Attr removeAttributeNode(Attr oldAttr) {
        this.removeAttribute(oldAttr.getName());
        return oldAttr;
    }

    @Override
    public NodeList getElementsByTagName(String name) {
        ArrayList l = new ArrayList();
        this.getElementsByTagName(name, l);
        return new IIONodeList(l);
    }

    private void getElementsByTagName(String name, List l) {
        if (this.nodeName.equals(name) || "*".equals(name)) {
            l.add(this);
        }
        for (Node child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            ((IIOMetadataNode)child).getElementsByTagName(name, l);
        }
    }

    @Override
    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        return this.getElementsByTagName(localName);
    }

    @Override
    public boolean hasAttributes() {
        return this.attributes.size() > 0;
    }

    @Override
    public boolean hasAttribute(String name) {
        return this.getAttributeNode(name) != null;
    }

    @Override
    public boolean hasAttributeNS(String namespaceURI, String localName) {
        return this.hasAttribute(localName);
    }

    @Override
    public int getLength() {
        return this.numChildren;
    }

    @Override
    public Node item(int index) {
        Node child;
        if (index < 0) {
            return null;
        }
        for (child = this.getFirstChild(); child != null && index-- > 0; child = child.getNextSibling()) {
        }
        return child;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    @Override
    public void setIdAttribute(String name, boolean isId) throws DOMException {
        throw new DOMException(9, "Method not supported");
    }

    @Override
    public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) throws DOMException {
        throw new DOMException(9, "Method not supported");
    }

    @Override
    public void setIdAttributeNode(Attr idAttr, boolean isId) throws DOMException {
        throw new DOMException(9, "Method not supported");
    }

    @Override
    public TypeInfo getSchemaTypeInfo() throws DOMException {
        throw new DOMException(9, "Method not supported");
    }

    @Override
    public Object setUserData(String key, Object data, UserDataHandler handler) throws DOMException {
        throw new DOMException(9, "Method not supported");
    }

    @Override
    public Object getUserData(String key) throws DOMException {
        throw new DOMException(9, "Method not supported");
    }

    @Override
    public Object getFeature(String feature, String version) throws DOMException {
        throw new DOMException(9, "Method not supported");
    }

    @Override
    public boolean isSameNode(Node node) throws DOMException {
        throw new DOMException(9, "Method not supported");
    }

    @Override
    public boolean isEqualNode(Node node) throws DOMException {
        throw new DOMException(9, "Method not supported");
    }

    @Override
    public String lookupNamespaceURI(String prefix) throws DOMException {
        throw new DOMException(9, "Method not supported");
    }

    @Override
    public boolean isDefaultNamespace(String namespaceURI) throws DOMException {
        throw new DOMException(9, "Method not supported");
    }

    @Override
    public String lookupPrefix(String namespaceURI) throws DOMException {
        throw new DOMException(9, "Method not supported");
    }

    @Override
    public String getTextContent() throws DOMException {
        throw new DOMException(9, "Method not supported");
    }

    @Override
    public void setTextContent(String textContent) throws DOMException {
        throw new DOMException(9, "Method not supported");
    }

    @Override
    public short compareDocumentPosition(Node other) throws DOMException {
        throw new DOMException(9, "Method not supported");
    }

    @Override
    public String getBaseURI() throws DOMException {
        throw new DOMException(9, "Method not supported");
    }
}

