/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl.krb5;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import javax.net.ssl.SSLKeyException;
import javax.security.auth.kerberos.KerberosKey;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.kerberos.ServicePermission;
import sun.security.jgss.GSSCaller;
import sun.security.jgss.krb5.Krb5Util;
import sun.security.jgss.krb5.ServiceCreds;
import sun.security.krb5.EncryptedData;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.KrbException;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.internal.EncTicketPart;
import sun.security.krb5.internal.Ticket;
import sun.security.ssl.Krb5Helper;
import sun.security.ssl.KrbClientKeyExchangeHelper;
import sun.security.ssl.SSLLogger;

public final class KrbClientKeyExchangeHelperImpl
implements KrbClientKeyExchangeHelper {
    private byte[] preMaster;
    private byte[] preMasterEnc;
    private byte[] encodedTicket;
    private KerberosPrincipal peerPrincipal;
    private KerberosPrincipal localPrincipal;

    @Override
    public void init(byte[] preMaster, String serverName, AccessControlContext acc) throws IOException {
        this.preMaster = preMaster;
        KerberosTicket ticket = KrbClientKeyExchangeHelperImpl.getServiceTicket(serverName, acc);
        this.encodedTicket = ticket.getEncoded();
        this.peerPrincipal = ticket.getServer();
        this.localPrincipal = ticket.getClient();
        EncryptionKey sessionKey = new EncryptionKey(ticket.getSessionKeyType(), ticket.getSessionKey().getEncoded());
        this.encryptPremasterSecret(sessionKey);
    }

    @Override
    public void init(byte[] encodedTicket, byte[] preMasterEnc, Object serviceCreds, AccessControlContext acc) throws IOException {
        EncryptionKey sessionKey;
        block13: {
            this.encodedTicket = encodedTicket;
            this.preMasterEnc = preMasterEnc;
            sessionKey = null;
            try {
                KerberosKey[] serverKeys;
                Ticket t = new Ticket(encodedTicket);
                EncryptedData encPart = t.encPart;
                PrincipalName ticketSname = t.sname;
                final ServiceCreds creds = (ServiceCreds)serviceCreds;
                final KerberosPrincipal princ = new KerberosPrincipal(ticketSname.toString());
                if (creds.getName() == null) {
                    SecurityManager sm = System.getSecurityManager();
                    try {
                        if (sm != null) {
                            sm.checkPermission(Krb5Helper.getServicePermission(ticketSname.toString(), "accept"), acc);
                        }
                    }
                    catch (SecurityException se) {
                        if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                            SSLLogger.fine("Permission to access Kerberos secret key denied", new Object[0]);
                        }
                        throw new IOException("Kerberos service not allowed");
                    }
                }
                if ((serverKeys = AccessController.doPrivileged(new PrivilegedAction<KerberosKey[]>(){

                    @Override
                    public KerberosKey[] run() {
                        return creds.getKKeys(princ);
                    }
                })).length == 0) {
                    throw new IOException("Found no key for " + princ + (creds.getName() == null ? "" : ", this keytab is for " + creds.getName() + " only"));
                }
                int encPartKeyType = encPart.getEType();
                Integer encPartKeyVersion = encPart.getKeyVersionNumber();
                KerberosKey dkey = null;
                try {
                    dkey = KrbClientKeyExchangeHelperImpl.findKey(encPartKeyType, encPartKeyVersion, serverKeys);
                }
                catch (KrbException ke) {
                    throw new IOException("Cannot find key matching version number", ke);
                }
                if (dkey == null) {
                    throw new IOException("Cannot find key of appropriate type to decrypt ticket - need etype " + encPartKeyType);
                }
                EncryptionKey secretKey = new EncryptionKey(encPartKeyType, dkey.getEncoded());
                byte[] bytes = encPart.decrypt(secretKey, 2);
                byte[] temp = encPart.reset(bytes);
                EncTicketPart encTicketPart = new EncTicketPart(temp);
                this.peerPrincipal = new KerberosPrincipal(encTicketPart.cname.getName());
                this.localPrincipal = new KerberosPrincipal(ticketSname.getName());
                sessionKey = encTicketPart.key;
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("server principal: " + ticketSname, new Object[0]);
                    SSLLogger.fine("cname: " + encTicketPart.cname.toString(), new Object[0]);
                }
            }
            catch (Exception e) {
                sessionKey = null;
                if (!SSLLogger.isOn || !SSLLogger.isOn("ssl,handshake")) break block13;
                SSLLogger.fine("Error getting the Kerberos session key to decrypt the pre-master secret", new Object[0]);
            }
        }
        if (sessionKey != null) {
            this.decryptPremasterSecret(sessionKey);
        }
    }

    @Override
    public byte[] getEncodedTicket() {
        return this.encodedTicket;
    }

    @Override
    public byte[] getEncryptedPreMasterSecret() {
        return this.preMasterEnc;
    }

    @Override
    public byte[] getPlainPreMasterSecret() {
        return this.preMaster;
    }

    @Override
    public KerberosPrincipal getPeerPrincipal() {
        return this.peerPrincipal;
    }

    @Override
    public KerberosPrincipal getLocalPrincipal() {
        return this.localPrincipal;
    }

    private void encryptPremasterSecret(EncryptionKey sessionKey) throws IOException {
        if (sessionKey.getEType() == 16) {
            throw new IOException("session keys with des3-cbc-hmac-sha1-kd encryption type are not supported for TLS Kerberos cipher suites");
        }
        try {
            EncryptedData eData = new EncryptedData(sessionKey, this.preMaster, 0);
            this.preMasterEnc = eData.getBytes();
        }
        catch (KrbException e) {
            throw (IOException)new SSLKeyException("Kerberos pre-master secret error").initCause(e);
        }
    }

    private void decryptPremasterSecret(EncryptionKey sessionKey) throws IOException {
        block8: {
            if (sessionKey.getEType() == 16) {
                throw new IOException("session keys with des3-cbc-hmac-sha1-kd encryption type are not supported for TLS Kerberos cipher suites");
            }
            try {
                EncryptedData data = new EncryptedData(sessionKey.getEType(), null, this.preMasterEnc);
                byte[] temp = data.decrypt(sessionKey, 0);
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake") && this.preMasterEnc != null) {
                    SSLLogger.fine("decrypted premaster secret", new Object[]{temp});
                }
                if (temp.length == 52 && data.getEType() == 1) {
                    if (KrbClientKeyExchangeHelperImpl.paddingByteIs(temp, 52, (byte)4) || KrbClientKeyExchangeHelperImpl.paddingByteIs(temp, 52, (byte)0)) {
                        temp = Arrays.copyOf(temp, 48);
                    }
                } else if (temp.length == 56 && data.getEType() == 3 && KrbClientKeyExchangeHelperImpl.paddingByteIs(temp, 56, (byte)8)) {
                    temp = Arrays.copyOf(temp, 48);
                }
                this.preMaster = temp;
            }
            catch (Exception e) {
                if (!SSLLogger.isOn || !SSLLogger.isOn("ssl,handshake")) break block8;
                SSLLogger.fine("Error decrypting the pre-master secret", new Object[0]);
            }
        }
    }

    private static boolean paddingByteIs(byte[] data, int len, byte b) {
        for (int i = 48; i < len; ++i) {
            if (data[i] == b) continue;
            return false;
        }
        return true;
    }

    private static KerberosTicket getServiceTicket(String serverName, final AccessControlContext acc) throws IOException {
        PrincipalName principal;
        if ("localhost".equals(serverName) || "localhost.localdomain".equals(serverName)) {
            String localHost;
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Get the local hostname", new Object[0]);
            }
            if ((localHost = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    try {
                        return InetAddress.getLocalHost().getHostName();
                    }
                    catch (UnknownHostException e) {
                        if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                            SSLLogger.fine("Warning, cannot get the local hostname: " + e.getMessage(), new Object[0]);
                        }
                        return null;
                    }
                }
            })) != null) {
                serverName = localHost;
            }
        }
        String serviceName = "host/" + serverName;
        try {
            principal = new PrincipalName(serviceName, 3);
        }
        catch (SecurityException se) {
            throw se;
        }
        catch (Exception e) {
            IOException ioe = new IOException("Invalid service principal name: " + serviceName);
            ioe.initCause(e);
            throw ioe;
        }
        String realm = principal.getRealmAsString();
        final String serverPrincipal = principal.toString();
        final String tgsPrincipal = "krbtgt/" + realm + "@" + realm;
        final String clientPrincipal = null;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new ServicePermission(serverPrincipal, "initiate"), acc);
        }
        try {
            KerberosTicket ticket = AccessController.doPrivileged(new PrivilegedExceptionAction<KerberosTicket>(){

                @Override
                public KerberosTicket run() throws Exception {
                    return Krb5Util.getTicketFromSubjectAndTgs((GSSCaller)GSSCaller.CALLER_SSL_CLIENT, (String)clientPrincipal, (String)serverPrincipal, (String)tgsPrincipal, (AccessControlContext)acc);
                }
            });
            if (ticket == null) {
                throw new IOException("Failed to find any kerberos service ticket for " + serverPrincipal);
            }
            return ticket;
        }
        catch (PrivilegedActionException e) {
            IOException ioe = new IOException("Attempt to obtain kerberos service ticket for " + serverPrincipal + " failed!");
            ioe.initCause(e);
            throw ioe;
        }
    }

    private static boolean versionMatches(Integer v1, int v2) {
        if (v1 == null || v1 == 0 || v2 == 0) {
            return true;
        }
        return v1.equals(v2);
    }

    private static KerberosKey findKey(int etype, Integer version, KerberosKey[] keys) throws KrbException {
        int kv;
        int ktype;
        int i;
        boolean etypeFound = false;
        int kvno_found = 0;
        KerberosKey key_found = null;
        for (i = 0; i < keys.length; ++i) {
            ktype = keys[i].getKeyType();
            if (etype != ktype) continue;
            kv = keys[i].getVersionNumber();
            etypeFound = true;
            if (KrbClientKeyExchangeHelperImpl.versionMatches(version, kv)) {
                return keys[i];
            }
            if (kv <= kvno_found) continue;
            key_found = keys[i];
            kvno_found = kv;
        }
        if (etype == 1 || etype == 3) {
            for (i = 0; i < keys.length; ++i) {
                ktype = keys[i].getKeyType();
                if (ktype != 1 && ktype != 3) continue;
                kv = keys[i].getVersionNumber();
                etypeFound = true;
                if (KrbClientKeyExchangeHelperImpl.versionMatches(version, kv)) {
                    return new KerberosKey(keys[i].getPrincipal(), keys[i].getEncoded(), etype, kv);
                }
                if (kv <= kvno_found) continue;
                key_found = new KerberosKey(keys[i].getPrincipal(), keys[i].getEncoded(), etype, kv);
                kvno_found = kv;
            }
        }
        if (etypeFound) {
            return key_found;
        }
        return null;
    }
}

