/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.LdapCtxFactory;
import com.sun.jndi.ldap.VersionHelper;
import com.sun.jndi.ldap.VersionHelper12;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.lang.reflect.Proxy;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InvalidAttributeValueException;
import javax.naming.directory.InvalidAttributesException;
import javax.naming.spi.DirStateFactory;
import javax.naming.spi.DirectoryManager;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

final class Obj {
    static VersionHelper helper = VersionHelper.getVersionHelper();
    static final String[] JAVA_ATTRIBUTES = new String[]{"objectClass", "javaSerializedData", "javaClassName", "javaFactory", "javaCodeBase", "javaReferenceAddress", "javaClassNames", "javaRemoteLocation"};
    static final int OBJECT_CLASS = 0;
    static final int SERIALIZED_DATA = 1;
    static final int CLASSNAME = 2;
    static final int FACTORY = 3;
    static final int CODEBASE = 4;
    static final int REF_ADDR = 5;
    static final int TYPENAME = 6;
    @Deprecated
    private static final int REMOTE_LOC = 7;
    static final String[] JAVA_OBJECT_CLASSES = new String[]{"javaContainer", "javaObject", "javaNamingReference", "javaSerializedObject", "javaMarshalledObject"};
    static final String[] JAVA_OBJECT_CLASSES_LOWER = new String[]{"javacontainer", "javaobject", "javanamingreference", "javaserializedobject", "javamarshalledobject"};
    static final int STRUCTURAL = 0;
    static final int BASE_OBJECT = 1;
    static final int REF_OBJECT = 2;
    static final int SER_OBJECT = 3;
    static final int MAR_OBJECT = 4;

    private Obj() {
    }

    private static Attributes encodeObject(char separator, Object obj, Attributes attrs, Attribute objectClass, boolean cloned) throws NamingException {
        boolean structural;
        boolean bl = structural = objectClass.size() == 0 || objectClass.size() == 1 && objectClass.contains("top");
        if (structural) {
            objectClass.add(JAVA_OBJECT_CLASSES[0]);
        }
        if (obj instanceof Referenceable) {
            objectClass.add(JAVA_OBJECT_CLASSES[1]);
            objectClass.add(JAVA_OBJECT_CLASSES[2]);
            if (!cloned) {
                attrs = (Attributes)attrs.clone();
            }
            attrs.put(objectClass);
            return Obj.encodeReference(separator, ((Referenceable)obj).getReference(), attrs, obj);
        }
        if (obj instanceof Reference) {
            objectClass.add(JAVA_OBJECT_CLASSES[1]);
            objectClass.add(JAVA_OBJECT_CLASSES[2]);
            if (!cloned) {
                attrs = (Attributes)attrs.clone();
            }
            attrs.put(objectClass);
            return Obj.encodeReference(separator, (Reference)obj, attrs, null);
        }
        if (obj instanceof Serializable) {
            Attribute tAttr;
            objectClass.add(JAVA_OBJECT_CLASSES[1]);
            if (!objectClass.contains(JAVA_OBJECT_CLASSES[4]) && !objectClass.contains(JAVA_OBJECT_CLASSES_LOWER[4])) {
                objectClass.add(JAVA_OBJECT_CLASSES[3]);
            }
            if (!cloned) {
                attrs = (Attributes)attrs.clone();
            }
            attrs.put(objectClass);
            attrs.put(new BasicAttribute(JAVA_ATTRIBUTES[1], Obj.serializeObject(obj)));
            if (attrs.get(JAVA_ATTRIBUTES[2]) == null) {
                attrs.put(JAVA_ATTRIBUTES[2], obj.getClass().getName());
            }
            if (attrs.get(JAVA_ATTRIBUTES[6]) == null && (tAttr = LdapCtxFactory.createTypeNameAttr(obj.getClass())) != null) {
                attrs.put(tAttr);
            }
        } else if (!(obj instanceof DirContext)) {
            throw new IllegalArgumentException("can only bind Referenceable, Serializable, DirContext");
        }
        return attrs;
    }

    private static String[] getCodebases(Attribute codebaseAttr) throws NamingException {
        if (codebaseAttr == null) {
            return null;
        }
        StringTokenizer parser = new StringTokenizer((String)codebaseAttr.get());
        Vector<String> vec = new Vector<String>(10);
        while (parser.hasMoreTokens()) {
            vec.addElement(parser.nextToken());
        }
        String[] answer = new String[vec.size()];
        for (int i = 0; i < answer.length; ++i) {
            answer[i] = (String)vec.elementAt(i);
        }
        return answer;
    }

    static Object decodeObject(Attributes attrs) throws NamingException {
        String[] codebases = Obj.getCodebases(attrs.get(JAVA_ATTRIBUTES[4]));
        try {
            Attribute attr = attrs.get(JAVA_ATTRIBUTES[1]);
            if (attr != null) {
                if (!VersionHelper12.isSerialDataAllowed()) {
                    throw new NamingException("Object deserialization is not allowed");
                }
                ClassLoader cl = helper.getURLClassLoader(codebases);
                return Obj.deserializeObject((byte[])attr.get(), cl);
            }
            attr = attrs.get(JAVA_ATTRIBUTES[7]);
            if (attr != null) {
                return Obj.decodeRmiObject((String)attrs.get(JAVA_ATTRIBUTES[2]).get(), (String)attr.get(), codebases);
            }
            attr = attrs.get(JAVA_ATTRIBUTES[0]);
            if (attr != null && (attr.contains(JAVA_OBJECT_CLASSES[2]) || attr.contains(JAVA_OBJECT_CLASSES_LOWER[2]))) {
                return Obj.decodeReference(attrs, codebases);
            }
            return null;
        }
        catch (IOException e) {
            NamingException ne = new NamingException();
            ne.setRootCause(e);
            throw ne;
        }
    }

    private static Attributes encodeReference(char separator, Reference ref, Attributes attrs, Object orig) throws NamingException {
        int count;
        Attribute tAttr;
        if (ref == null) {
            return attrs;
        }
        String s = ref.getClassName();
        if (s != null) {
            attrs.put(new BasicAttribute(JAVA_ATTRIBUTES[2], s));
        }
        if ((s = ref.getFactoryClassName()) != null) {
            attrs.put(new BasicAttribute(JAVA_ATTRIBUTES[3], s));
        }
        if ((s = ref.getFactoryClassLocation()) != null) {
            attrs.put(new BasicAttribute(JAVA_ATTRIBUTES[4], s));
        }
        if (orig != null && attrs.get(JAVA_ATTRIBUTES[6]) != null && (tAttr = LdapCtxFactory.createTypeNameAttr(orig.getClass())) != null) {
            attrs.put(tAttr);
        }
        if ((count = ref.size()) > 0) {
            BasicAttribute refAttr = new BasicAttribute(JAVA_ATTRIBUTES[5]);
            BASE64Encoder encoder = null;
            for (int i = 0; i < count; ++i) {
                RefAddr refAddr = ref.get(i);
                if (refAddr instanceof StringRefAddr) {
                    refAttr.add("" + separator + i + separator + refAddr.getType() + separator + refAddr.getContent());
                    continue;
                }
                if (encoder == null) {
                    encoder = new BASE64Encoder();
                }
                refAttr.add("" + separator + i + separator + refAddr.getType() + separator + separator + encoder.encodeBuffer(Obj.serializeObject(refAddr)));
            }
            attrs.put(refAttr);
        }
        return attrs;
    }

    private static Object decodeRmiObject(String className, String rmiName, String[] codebases) throws NamingException {
        return new Reference(className, new StringRefAddr("URL", rmiName));
    }

    private static Reference decodeReference(Attributes attrs, String[] codebases) throws NamingException, IOException {
        String factory = null;
        Attribute attr = attrs.get(JAVA_ATTRIBUTES[2]);
        if (attr == null) {
            throw new InvalidAttributesException(JAVA_ATTRIBUTES[2] + " attribute is required");
        }
        String className = (String)attr.get();
        attr = attrs.get(JAVA_ATTRIBUTES[3]);
        if (attr != null) {
            factory = (String)attr.get();
        }
        Reference ref = new Reference(className, factory, codebases != null ? codebases[0] : null);
        attr = attrs.get(JAVA_ATTRIBUTES[5]);
        if (attr != null) {
            BASE64Decoder decoder = null;
            ClassLoader cl = helper.getURLClassLoader(codebases);
            Vector<RefAddr> refAddrList = new Vector<RefAddr>();
            refAddrList.setSize(attr.size());
            NamingEnumeration<?> vals = attr.getAll();
            while (vals.hasMore()) {
                int posn;
                int start;
                String val = (String)vals.next();
                if (val.length() == 0) {
                    throw new InvalidAttributeValueException("malformed " + JAVA_ATTRIBUTES[5] + " attribute - empty attribute value");
                }
                char separator = val.charAt(0);
                int sep = val.indexOf(separator, start = 1);
                if (sep < 0) {
                    throw new InvalidAttributeValueException("malformed " + JAVA_ATTRIBUTES[5] + " attribute - separator '" + separator + "'not found");
                }
                String posnStr = val.substring(start, sep);
                if (posnStr == null) {
                    throw new InvalidAttributeValueException("malformed " + JAVA_ATTRIBUTES[5] + " attribute - empty RefAddr position");
                }
                try {
                    posn = Integer.parseInt(posnStr);
                }
                catch (NumberFormatException nfe) {
                    throw new InvalidAttributeValueException("malformed " + JAVA_ATTRIBUTES[5] + " attribute - RefAddr position not an integer");
                }
                start = sep + 1;
                sep = val.indexOf(separator, start);
                if (sep < 0) {
                    throw new InvalidAttributeValueException("malformed " + JAVA_ATTRIBUTES[5] + " attribute - RefAddr type not found");
                }
                String type = val.substring(start, sep);
                if (type == null) {
                    throw new InvalidAttributeValueException("malformed " + JAVA_ATTRIBUTES[5] + " attribute - empty RefAddr type");
                }
                start = sep + 1;
                if (start == val.length()) {
                    refAddrList.setElementAt(new StringRefAddr(type, null), posn);
                    continue;
                }
                if (val.charAt(start) == separator) {
                    if (!VersionHelper12.isSerialDataAllowed()) {
                        throw new NamingException("Object deserialization is not allowed");
                    }
                    ++start;
                    if (decoder == null) {
                        decoder = new BASE64Decoder();
                    }
                    RefAddr ra = (RefAddr)Obj.deserializeObject(decoder.decodeBuffer(val.substring(start)), cl);
                    refAddrList.setElementAt(ra, posn);
                    continue;
                }
                refAddrList.setElementAt(new StringRefAddr(type, val.substring(start)), posn);
            }
            for (int i = 0; i < refAddrList.size(); ++i) {
                ref.add((RefAddr)refAddrList.elementAt(i));
            }
        }
        return ref;
    }

    private static byte[] serializeObject(Object obj) throws NamingException {
        try {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            try (ObjectOutputStream serial = new ObjectOutputStream(bytes);){
                serial.writeObject(obj);
            }
            return bytes.toByteArray();
        }
        catch (IOException e) {
            NamingException ne = new NamingException();
            ne.setRootCause(e);
            throw ne;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Object deserializeObject(byte[] obj, ClassLoader cl) throws NamingException {
        try {
            ByteArrayInputStream bytes = new ByteArrayInputStream(obj);
            try (ObjectInputStream deserial = cl == null ? new ObjectInputStream(bytes) : new LoaderInputStream(bytes, cl);){
                Object object = deserial.readObject();
                return object;
            }
            catch (ClassNotFoundException e) {
                NamingException ne = new NamingException();
                ne.setRootCause(e);
                throw ne;
            }
        }
        catch (IOException e) {
            NamingException ne = new NamingException();
            ne.setRootCause(e);
            throw ne;
        }
    }

    static Attributes determineBindAttrs(char separator, Object obj, Attributes attrs, boolean cloned, Name name, Context ctx, Hashtable<?, ?> env) throws NamingException {
        Attribute objectClass;
        DirStateFactory.Result res = DirectoryManager.getStateToBind(obj, name, ctx, env, attrs);
        obj = res.getObject();
        attrs = res.getAttributes();
        if (obj == null) {
            return attrs;
        }
        if (attrs == null && obj instanceof DirContext) {
            cloned = true;
            attrs = ((DirContext)obj).getAttributes("");
        }
        boolean ocNeedsCloning = false;
        if (attrs == null || attrs.size() == 0) {
            attrs = new BasicAttributes(true);
            cloned = true;
            objectClass = new BasicAttribute("objectClass", "top");
        } else {
            objectClass = attrs.get("objectClass");
            if (objectClass == null && !attrs.isCaseIgnored()) {
                objectClass = attrs.get("objectclass");
            }
            if (objectClass == null) {
                objectClass = new BasicAttribute("objectClass", "top");
            } else if (ocNeedsCloning || !cloned) {
                objectClass = (Attribute)objectClass.clone();
            }
        }
        attrs = Obj.encodeObject(separator, obj, attrs, objectClass, cloned);
        return attrs;
    }

    private static final class LoaderInputStream
    extends ObjectInputStream {
        private ClassLoader classLoader;

        LoaderInputStream(InputStream in, ClassLoader cl) throws IOException {
            super(in);
            this.classLoader = cl;
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            try {
                return this.classLoader.loadClass(desc.getName());
            }
            catch (ClassNotFoundException e) {
                return super.resolveClass(desc);
            }
        }

        @Override
        protected Class<?> resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
            ClassLoader nonPublicLoader = null;
            boolean hasNonPublicInterface = false;
            Class[] classObjs = new Class[interfaces.length];
            for (int i = 0; i < interfaces.length; ++i) {
                Class<?> cl = Class.forName(interfaces[i], false, this.classLoader);
                if ((cl.getModifiers() & 1) == 0) {
                    if (hasNonPublicInterface) {
                        if (nonPublicLoader != cl.getClassLoader()) {
                            throw new IllegalAccessError("conflicting non-public interface class loaders");
                        }
                    } else {
                        nonPublicLoader = cl.getClassLoader();
                        hasNonPublicInterface = true;
                    }
                }
                classObjs[i] = cl;
            }
            try {
                return Proxy.getProxyClass(hasNonPublicInterface ? nonPublicLoader : this.classLoader, classObjs);
            }
            catch (IllegalArgumentException e) {
                throw new ClassNotFoundException(null, e);
            }
        }
    }
}

