/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.dns;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.ProtocolFamily;
import java.net.SocketException;
import java.nio.channels.DatagramChannel;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Objects;
import java.util.Random;
import sun.net.PortConfig;

class DNSDatagramSocketFactory {
    static final int DEVIATION = 3;
    static final int THRESHOLD = 6;
    static final int BIT_DEVIATION = 2;
    static final int HISTORY = 32;
    static final int MAX_RANDOM_TRIES = 5;
    int lastport;
    int lastSystemAllocated;
    int suitablePortCount;
    int unsuitablePortCount;
    final ProtocolFamily family;
    final int thresholdCount;
    final int deviation;
    final Random random;
    final PortHistory history;

    private static int findFirstFreePort() {
        int port;
        PrivilegedExceptionAction<DatagramSocket> action = () -> new DatagramSocket(0);
        try {
            DatagramSocket ds;
            try (DatagramSocket ds1 = ds = AccessController.doPrivileged(action);){
                port = ds1.getLocalPort();
            }
        }
        catch (Exception x) {
            port = 0;
        }
        return port;
    }

    DNSDatagramSocketFactory() {
        this(new Random());
    }

    DNSDatagramSocketFactory(Random random) {
        this(Objects.requireNonNull(random), null, 3, 6);
    }

    DNSDatagramSocketFactory(Random random, ProtocolFamily family, int deviation, int threshold) {
        this.lastSystemAllocated = this.lastport = DNSDatagramSocketFactory.findFirstFreePort();
        this.random = Objects.requireNonNull(random);
        this.history = new PortHistory(32, random);
        this.family = family;
        this.deviation = Math.max(1, deviation);
        this.thresholdCount = Math.max(2, threshold);
    }

    public synchronized DatagramSocket open() throws SocketException {
        boolean suitable;
        DatagramSocket s;
        boolean thresholdCrossed;
        int lastseen = this.lastport;
        boolean bl = thresholdCrossed = this.unsuitablePortCount > this.thresholdCount;
        if (thresholdCrossed) {
            s = this.openRandom();
            if (s != null) {
                return s;
            }
            this.unsuitablePortCount = 0;
            this.suitablePortCount = 0;
            lastseen = 0;
        }
        s = this.openDefault();
        this.lastport = s.getLocalPort();
        if (lastseen == 0) {
            this.lastSystemAllocated = this.lastport;
            this.history.offer(this.lastport);
            return s;
        }
        thresholdCrossed = this.suitablePortCount > this.thresholdCount;
        boolean farEnough = this.farEnough(lastseen);
        if (farEnough && this.lastSystemAllocated > 0) {
            farEnough = this.farEnough(this.lastSystemAllocated);
        }
        boolean recycled = this.history.contains(this.lastport);
        boolean bl2 = suitable = thresholdCrossed || farEnough && !recycled;
        if (suitable && !recycled) {
            this.history.add(this.lastport);
        }
        if (suitable) {
            if (!thresholdCrossed) {
                ++this.suitablePortCount;
            } else if (!farEnough || recycled) {
                this.unsuitablePortCount = 1;
                this.suitablePortCount = this.thresholdCount / 2;
            }
            this.lastSystemAllocated = this.lastport;
            return s;
        }
        assert (!thresholdCrossed);
        DatagramSocket ss = this.openRandom();
        if (ss == null) {
            return s;
        }
        ++this.unsuitablePortCount;
        s.close();
        return ss;
    }

    private DatagramSocket openDefault() throws SocketException {
        if (this.family != null) {
            try {
                DatagramChannel c = DatagramChannel.open(this.family);
                try {
                    DatagramSocket s = c.socket();
                    s.bind(null);
                    return s;
                }
                catch (Throwable x) {
                    c.close();
                    throw x;
                }
            }
            catch (SocketException x) {
                throw x;
            }
            catch (IOException x) {
                SocketException e = new SocketException(x.getMessage());
                e.initCause(x);
                throw e;
            }
        }
        return new DatagramSocket();
    }

    synchronized boolean isUsingNativePortRandomization() {
        return this.unsuitablePortCount <= this.thresholdCount && this.suitablePortCount > this.thresholdCount;
    }

    synchronized boolean isUsingJavaPortRandomization() {
        return this.unsuitablePortCount > this.thresholdCount;
    }

    synchronized boolean isUndecided() {
        return !this.isUsingJavaPortRandomization() && !this.isUsingNativePortRandomization();
    }

    private boolean farEnough(int port) {
        return Integer.bitCount(port ^ this.lastport) > 2 && Math.abs(port - this.lastport) > this.deviation;
    }

    private DatagramSocket openRandom() {
        int maxtries = 5;
        while (maxtries-- > 0) {
            boolean recycled;
            int port;
            boolean suitable;
            int maxrandom = 5;
            do {
                port = EphemeralPortRange.LOWER + this.random.nextInt(EphemeralPortRange.RANGE);
                recycled = this.history.contains(port);
                boolean bl = suitable = this.lastport == 0 || this.farEnough(port) && !recycled;
            } while (maxrandom-- > 0 && !suitable);
            if (!suitable) continue;
            try {
                if (this.family != null) {
                    DatagramChannel c = DatagramChannel.open(this.family);
                    try {
                        DatagramSocket s = c.socket();
                        s.bind(new InetSocketAddress(port));
                        this.lastport = s.getLocalPort();
                        if (!recycled) {
                            this.history.add(port);
                        }
                        return s;
                    }
                    catch (Throwable x) {
                        c.close();
                        throw x;
                    }
                }
                DatagramSocket s = new DatagramSocket(port);
                this.lastport = s.getLocalPort();
                if (!recycled) {
                    this.history.add(port);
                }
                return s;
            }
            catch (IOException iOException) {
            }
        }
        return null;
    }

    static final class PortHistory {
        final int capacity;
        final int[] ports;
        final Random random;
        int index;

        PortHistory(int capacity, Random random) {
            this.random = random;
            this.capacity = capacity;
            this.ports = new int[capacity];
        }

        public boolean contains(int port) {
            int p = 0;
            for (int i = 0; i < this.capacity && (p = this.ports[i]) != 0 && p != port; ++i) {
            }
            return p == port;
        }

        public boolean add(int port) {
            if (this.ports[this.index] != 0) {
                int remove = this.random.nextInt(this.capacity);
                if ((remove + 1) % this.capacity == this.index) {
                    remove = this.index;
                }
                this.index = remove;
                this.ports[this.index] = port;
            } else {
                this.ports[this.index] = port;
            }
            if (++this.index == this.capacity) {
                this.index = 0;
            }
            return true;
        }

        public boolean offer(int port) {
            if (this.contains(port)) {
                return false;
            }
            return this.add(port);
        }
    }

    static final class EphemeralPortRange {
        static final int LOWER = PortConfig.getLower();
        static final int UPPER = PortConfig.getUpper();
        static final int RANGE = UPPER - LOWER + 1;

        private EphemeralPortRange() {
        }
    }
}

