/*
 * Decompiled with CFR 0.152.
 */
package java.awt.font;

import java.awt.Font;
import java.awt.font.CharArrayIterator;
import java.awt.font.FontRenderContext;
import java.awt.font.GraphicAttribute;
import java.awt.font.LineMetrics;
import java.awt.font.NumericShaper;
import java.awt.font.StyledParagraph;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.font.TextLine;
import java.text.AttributedCharacterIterator;
import java.text.Bidi;
import java.text.BreakIterator;
import java.util.Hashtable;
import java.util.Map;
import sun.font.AttributeValues;
import sun.font.BidiUtils;
import sun.font.TextLabelFactory;
import sun.font.TextLineComponent;

public final class TextMeasurer
implements Cloneable {
    private static float EST_LINES = 2.1f;
    private FontRenderContext fFrc;
    private int fStart;
    private char[] fChars;
    private Bidi fBidi;
    private byte[] fLevels;
    private TextLineComponent[] fComponents;
    private int fComponentStart;
    private int fComponentLimit;
    private boolean haveLayoutWindow;
    private BreakIterator fLineBreak = null;
    private CharArrayIterator charIter = null;
    int layoutCount = 0;
    int layoutCharCount = 0;
    private StyledParagraph fParagraph;
    private boolean fIsDirectionLTR;
    private byte fBaseline;
    private float[] fBaselineOffsets;
    private float fJustifyRatio = 1.0f;
    private int formattedChars = 0;
    private static boolean wantStats = false;
    private boolean collectStats = false;

    public TextMeasurer(AttributedCharacterIterator text, FontRenderContext frc) {
        this.fFrc = frc;
        this.initAll(text);
    }

    protected Object clone() {
        TextMeasurer other;
        try {
            other = (TextMeasurer)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error();
        }
        if (this.fComponents != null) {
            other.fComponents = (TextLineComponent[])this.fComponents.clone();
        }
        return other;
    }

    private void invalidateComponents() {
        this.fComponentStart = this.fComponentLimit = this.fChars.length;
        this.fComponents = null;
        this.haveLayoutWindow = false;
    }

    private void initAll(AttributedCharacterIterator text) {
        this.fStart = text.getBeginIndex();
        this.fChars = new char[text.getEndIndex() - this.fStart];
        int n = 0;
        char c = text.first();
        while (c != '\uffff') {
            this.fChars[n++] = c;
            c = text.next();
        }
        text.first();
        this.fBidi = new Bidi(text);
        if (this.fBidi.isLeftToRight()) {
            this.fBidi = null;
        }
        text.first();
        Map<AttributedCharacterIterator.Attribute, Object> paragraphAttrs = text.getAttributes();
        NumericShaper shaper = AttributeValues.getNumericShaping(paragraphAttrs);
        if (shaper != null) {
            shaper.shape(this.fChars, 0, this.fChars.length);
        }
        this.fParagraph = new StyledParagraph(text, this.fChars);
        this.fJustifyRatio = AttributeValues.getJustification(paragraphAttrs);
        boolean haveFont = TextLine.advanceToFirstFont(text);
        if (haveFont) {
            Font defaultFont = TextLine.getFontAtCurrentPos(text);
            int charsStart = text.getIndex() - text.getBeginIndex();
            LineMetrics lm = defaultFont.getLineMetrics(this.fChars, charsStart, charsStart + 1, this.fFrc);
            this.fBaseline = (byte)lm.getBaselineIndex();
            this.fBaselineOffsets = lm.getBaselineOffsets();
        } else {
            GraphicAttribute graphic = (GraphicAttribute)paragraphAttrs.get(TextAttribute.CHAR_REPLACEMENT);
            this.fBaseline = TextLayout.getBaselineFromGraphic(graphic);
            Hashtable fmap = new Hashtable(5, 0.9f);
            Font dummyFont = new Font(fmap);
            LineMetrics lm = dummyFont.getLineMetrics(" ", 0, 1, this.fFrc);
            this.fBaselineOffsets = lm.getBaselineOffsets();
        }
        this.fBaselineOffsets = TextLine.getNormalizedOffsets(this.fBaselineOffsets, this.fBaseline);
        this.invalidateComponents();
    }

    private void generateComponents(int startingAt, int endingAt) {
        if (this.collectStats) {
            this.formattedChars += endingAt - startingAt;
        }
        int layoutFlags = 0;
        TextLabelFactory factory = new TextLabelFactory(this.fFrc, this.fChars, this.fBidi, layoutFlags);
        int[] charsLtoV = null;
        if (this.fBidi != null) {
            this.fLevels = BidiUtils.getLevels(this.fBidi);
            int[] charsVtoL = BidiUtils.createVisualToLogicalMap(this.fLevels);
            charsLtoV = BidiUtils.createInverseMap(charsVtoL);
            this.fIsDirectionLTR = this.fBidi.baseIsLeftToRight();
        } else {
            this.fLevels = null;
            this.fIsDirectionLTR = true;
        }
        try {
            this.fComponents = TextLine.getComponents(this.fParagraph, this.fChars, startingAt, endingAt, charsLtoV, this.fLevels, factory);
        }
        catch (IllegalArgumentException e) {
            System.out.println("startingAt=" + startingAt + "; endingAt=" + endingAt);
            System.out.println("fComponentLimit=" + this.fComponentLimit);
            throw e;
        }
        this.fComponentStart = startingAt;
        this.fComponentLimit = endingAt;
    }

    private int calcLineBreak(int pos, float maxAdvance) {
        int gaLimit;
        int tlcIndex;
        int startPos = pos;
        float width = maxAdvance;
        int tlcStart = this.fComponentStart;
        for (tlcIndex = 0; tlcIndex < this.fComponents.length && (gaLimit = tlcStart + this.fComponents[tlcIndex].getNumCharacters()) <= startPos; ++tlcIndex) {
            tlcStart = gaLimit;
        }
        while (tlcIndex < this.fComponents.length) {
            TextLineComponent tlc = this.fComponents[tlcIndex];
            int numCharsInGa = tlc.getNumCharacters();
            int lineBreak = tlc.getLineBreakIndex(startPos - tlcStart, width);
            if (lineBreak == numCharsInGa && tlcIndex < this.fComponents.length) {
                width -= tlc.getAdvanceBetween(startPos - tlcStart, lineBreak);
            } else {
                return tlcStart + lineBreak;
            }
            startPos = tlcStart += numCharsInGa;
            ++tlcIndex;
        }
        if (this.fComponentLimit < this.fChars.length) {
            this.generateComponents(pos, this.fChars.length);
            return this.calcLineBreak(pos, maxAdvance);
        }
        return this.fChars.length;
    }

    private int trailingCdWhitespaceStart(int startPos, int limitPos) {
        if (this.fLevels != null) {
            byte baseLevel = (byte)(!this.fIsDirectionLTR ? 1 : 0);
            int cdWsStart = limitPos;
            while (--cdWsStart >= startPos) {
                if (this.fLevels[cdWsStart] % 2 != baseLevel && Character.getDirectionality(this.fChars[cdWsStart]) == 12) continue;
                return ++cdWsStart;
            }
        }
        return startPos;
    }

    private TextLineComponent[] makeComponentsOnRange(int startPos, int limitPos) {
        int subsetFlag;
        int gaLimit;
        int tlcIndex;
        int cdWsStart = this.trailingCdWhitespaceStart(startPos, limitPos);
        int tlcStart = this.fComponentStart;
        for (tlcIndex = 0; tlcIndex < this.fComponents.length && (gaLimit = tlcStart + this.fComponents[tlcIndex].getNumCharacters()) <= startPos; ++tlcIndex) {
            tlcStart = gaLimit;
        }
        boolean split = false;
        int compStart = tlcStart;
        int lim = tlcIndex;
        boolean cont = true;
        while (cont) {
            int gaLimit2 = compStart + this.fComponents[lim].getNumCharacters();
            if (cdWsStart > Math.max(compStart, startPos) && cdWsStart < Math.min(gaLimit2, limitPos)) {
                split = true;
            }
            if (gaLimit2 >= limitPos) {
                cont = false;
            } else {
                compStart = gaLimit2;
            }
            ++lim;
        }
        int componentCount = lim - tlcIndex;
        if (split) {
            ++componentCount;
        }
        TextLineComponent[] components = new TextLineComponent[componentCount];
        int newCompIndex = 0;
        int linePos = startPos;
        int breakPt = cdWsStart;
        if (breakPt == startPos) {
            subsetFlag = this.fIsDirectionLTR ? 0 : 1;
            breakPt = limitPos;
        } else {
            subsetFlag = 2;
        }
        while (linePos < limitPos) {
            int compLength = this.fComponents[tlcIndex].getNumCharacters();
            int tlcLimit = tlcStart + compLength;
            int start = Math.max(linePos, tlcStart);
            int limit = Math.min(breakPt, tlcLimit);
            components[newCompIndex++] = this.fComponents[tlcIndex].getSubset(start - tlcStart, limit - tlcStart, subsetFlag);
            if ((linePos += limit - start) == breakPt) {
                breakPt = limitPos;
                int n = subsetFlag = this.fIsDirectionLTR ? 0 : 1;
            }
            if (linePos != tlcLimit) continue;
            ++tlcIndex;
            tlcStart = tlcLimit;
        }
        return components;
    }

    private TextLine makeTextLineOnRange(int startPos, int limitPos) {
        int[] charsLtoV = null;
        byte[] charLevels = null;
        if (this.fBidi != null) {
            Bidi lineBidi = this.fBidi.createLineBidi(startPos, limitPos);
            charLevels = BidiUtils.getLevels(lineBidi);
            int[] charsVtoL = BidiUtils.createVisualToLogicalMap(charLevels);
            charsLtoV = BidiUtils.createInverseMap(charsVtoL);
        }
        TextLineComponent[] components = this.makeComponentsOnRange(startPos, limitPos);
        return new TextLine(this.fFrc, components, this.fBaselineOffsets, this.fChars, startPos, limitPos, charsLtoV, charLevels, this.fIsDirectionLTR);
    }

    private void ensureComponents(int start, int limit) {
        if (start < this.fComponentStart || limit > this.fComponentLimit) {
            this.generateComponents(start, limit);
        }
    }

    private void makeLayoutWindow(int localStart) {
        int compStart = localStart;
        int compLimit = this.fChars.length;
        if (this.layoutCount > 0 && !this.haveLayoutWindow) {
            float avgLineLength = Math.max(this.layoutCharCount / this.layoutCount, 1);
            compLimit = Math.min(localStart + (int)(avgLineLength * EST_LINES), this.fChars.length);
        }
        if (localStart > 0 || compLimit < this.fChars.length) {
            if (this.charIter == null) {
                this.charIter = new CharArrayIterator(this.fChars);
            } else {
                this.charIter.reset(this.fChars);
            }
            if (this.fLineBreak == null) {
                this.fLineBreak = BreakIterator.getLineInstance();
            }
            this.fLineBreak.setText(this.charIter);
            if (localStart > 0 && !this.fLineBreak.isBoundary(localStart)) {
                compStart = this.fLineBreak.preceding(localStart);
            }
            if (compLimit < this.fChars.length && !this.fLineBreak.isBoundary(compLimit)) {
                compLimit = this.fLineBreak.following(compLimit);
            }
        }
        this.ensureComponents(compStart, compLimit);
        this.haveLayoutWindow = true;
    }

    public int getLineBreakIndex(int start, float maxAdvance) {
        int localStart = start - this.fStart;
        if (!this.haveLayoutWindow || localStart < this.fComponentStart || localStart >= this.fComponentLimit) {
            this.makeLayoutWindow(localStart);
        }
        return this.calcLineBreak(localStart, maxAdvance) + this.fStart;
    }

    public float getAdvanceBetween(int start, int limit) {
        int localStart = start - this.fStart;
        int localLimit = limit - this.fStart;
        this.ensureComponents(localStart, localLimit);
        TextLine line = this.makeTextLineOnRange(localStart, localLimit);
        return line.getMetrics().advance;
    }

    public TextLayout getLayout(int start, int limit) {
        int localStart = start - this.fStart;
        int localLimit = limit - this.fStart;
        this.ensureComponents(localStart, localLimit);
        TextLine textLine = this.makeTextLineOnRange(localStart, localLimit);
        if (localLimit < this.fChars.length) {
            this.layoutCharCount += limit - start;
            ++this.layoutCount;
        }
        return new TextLayout(textLine, this.fBaseline, this.fBaselineOffsets, this.fJustifyRatio);
    }

    private void printStats() {
        System.out.println("formattedChars: " + this.formattedChars);
        this.collectStats = false;
    }

    public void insertChar(AttributedCharacterIterator newParagraph, int insertPos) {
        char newChar;
        if (this.collectStats) {
            this.printStats();
        }
        if (wantStats) {
            this.collectStats = true;
        }
        this.fStart = newParagraph.getBeginIndex();
        int end = newParagraph.getEndIndex();
        if (end - this.fStart != this.fChars.length + 1) {
            this.initAll(newParagraph);
        }
        char[] newChars = new char[end - this.fStart];
        int newCharIndex = insertPos - this.fStart;
        System.arraycopy(this.fChars, 0, newChars, 0, newCharIndex);
        newChars[newCharIndex] = newChar = newParagraph.setIndex(insertPos);
        System.arraycopy(this.fChars, newCharIndex, newChars, newCharIndex + 1, end - insertPos - 1);
        this.fChars = newChars;
        if (this.fBidi != null || Bidi.requiresBidi(newChars, newCharIndex, newCharIndex + 1) || newParagraph.getAttribute(TextAttribute.BIDI_EMBEDDING) != null) {
            this.fBidi = new Bidi(newParagraph);
            if (this.fBidi.isLeftToRight()) {
                this.fBidi = null;
            }
        }
        this.fParagraph = StyledParagraph.insertChar(newParagraph, this.fChars, insertPos, this.fParagraph);
        this.invalidateComponents();
    }

    public void deleteChar(AttributedCharacterIterator newParagraph, int deletePos) {
        this.fStart = newParagraph.getBeginIndex();
        int end = newParagraph.getEndIndex();
        if (end - this.fStart != this.fChars.length - 1) {
            this.initAll(newParagraph);
        }
        char[] newChars = new char[end - this.fStart];
        int changedIndex = deletePos - this.fStart;
        System.arraycopy(this.fChars, 0, newChars, 0, deletePos - this.fStart);
        System.arraycopy(this.fChars, changedIndex + 1, newChars, changedIndex, end - deletePos);
        this.fChars = newChars;
        if (this.fBidi != null) {
            this.fBidi = new Bidi(newParagraph);
            if (this.fBidi.isLeftToRight()) {
                this.fBidi = null;
            }
        }
        this.fParagraph = StyledParagraph.deleteChar(newParagraph, this.fChars, deletePos, this.fParagraph);
        this.invalidateComponents();
    }

    char[] getChars() {
        return this.fChars;
    }
}

