/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.HeapLongBufferR;
import java.nio.LongBuffer;

class HeapLongBuffer
extends LongBuffer {
    HeapLongBuffer(int cap, int lim) {
        super(-1, 0, lim, cap, new long[cap], 0);
    }

    HeapLongBuffer(long[] buf, int off, int len) {
        super(-1, off, off + len, buf.length, buf, 0);
    }

    protected HeapLongBuffer(long[] buf, int mark, int pos, int lim, int cap, int off) {
        super(mark, pos, lim, cap, buf, off);
    }

    @Override
    public LongBuffer slice() {
        int lim;
        int pos = this.position();
        int rem = pos <= (lim = this.limit()) ? lim - pos : 0;
        return new HeapLongBuffer(this.hb, -1, 0, rem, rem, pos + this.offset);
    }

    @Override
    public LongBuffer duplicate() {
        return new HeapLongBuffer(this.hb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    @Override
    public LongBuffer asReadOnlyBuffer() {
        return new HeapLongBufferR(this.hb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    protected int ix(int i) {
        return i + this.offset;
    }

    @Override
    public long get() {
        return this.hb[this.ix(this.nextGetIndex())];
    }

    @Override
    public long get(int i) {
        return this.hb[this.ix(this.checkIndex(i))];
    }

    @Override
    public LongBuffer get(long[] dst, int offset, int length) {
        HeapLongBuffer.checkBounds(offset, length, dst.length);
        int pos = this.position();
        if (length > this.limit() - pos) {
            throw new BufferUnderflowException();
        }
        System.arraycopy(this.hb, this.ix(pos), dst, offset, length);
        this.position(pos + length);
        return this;
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public LongBuffer put(long x) {
        this.hb[this.ix((int)this.nextPutIndex())] = x;
        return this;
    }

    @Override
    public LongBuffer put(int i, long x) {
        this.hb[this.ix((int)this.checkIndex((int)i))] = x;
        return this;
    }

    @Override
    public LongBuffer put(long[] src, int offset, int length) {
        HeapLongBuffer.checkBounds(offset, length, src.length);
        int pos = this.position();
        if (length > this.limit() - pos) {
            throw new BufferOverflowException();
        }
        System.arraycopy(src, offset, this.hb, this.ix(pos), length);
        this.position(pos + length);
        return this;
    }

    @Override
    public LongBuffer put(LongBuffer src) {
        if (src instanceof HeapLongBuffer) {
            if (src == this) {
                throw new IllegalArgumentException();
            }
            HeapLongBuffer sb = (HeapLongBuffer)src;
            int pos = this.position();
            int sbpos = sb.position();
            int n = sb.limit() - sbpos;
            if (n > this.limit() - pos) {
                throw new BufferOverflowException();
            }
            System.arraycopy(sb.hb, sb.ix(sbpos), this.hb, this.ix(pos), n);
            sb.position(sbpos + n);
            this.position(pos + n);
        } else if (src.isDirect()) {
            int n = src.remaining();
            int pos = this.position();
            if (n > this.limit() - pos) {
                throw new BufferOverflowException();
            }
            src.get(this.hb, this.ix(pos), n);
            this.position(pos + n);
        } else {
            super.put(src);
        }
        return this;
    }

    @Override
    public LongBuffer compact() {
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        int rem = pos <= lim ? lim - pos : 0;
        System.arraycopy(this.hb, this.ix(pos), this.hb, this.ix(0), rem);
        this.position(rem);
        this.limit(this.capacity());
        this.discardMark();
        return this;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.nativeOrder();
    }
}

